/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.ntfy.eventchain;

import com.ibm.hwmca.fw.ntfy.DescriptiveObject;
import com.ibm.hwmca.fw.ntfy.eventchain.ChainedObject;
import com.ibm.hwmca.fw.ntfy.eventchain.Linkable;
import com.ibm.hwmca.fw.util.Trace;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;

public class ChainLink
implements Serializable,
Linkable {
    static final long serialVersionUID = -831646834475163708L;
    private static final String TRACE_MASKT = "XNTYCHLT";
    private static final String TRACE_MASKF = "XNTYCHLF";
    private static final String TRACE_MASKD = "XNTYCHLD";
    private ChainedObject _obj = null;
    private ArrayList _listeners = new ArrayList();
    private boolean _deleted = false;

    public ChainLink() {
    }

    public ChainLink(ChainedObject obj) {
        this._obj = obj;
    }

    public ChainedObject getChainedObject() {
        this._obj = this._deleted ? null : this._obj.getCurrent();
        return this._obj;
    }

    public boolean isDeleted() {
        return this.getChainedObject() == null;
    }

    public void delete() {
        this.getListeners().clear();
        this._obj = null;
        this._deleted = true;
    }

    protected List getListeners() {
        return this._listeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventListener(Linkable link) {
        ArrayList arrayList = this._listeners;
        synchronized (arrayList) {
            this.getListeners().add(link);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEventListener(Linkable link) {
        ArrayList arrayList = this._listeners;
        synchronized (arrayList) {
            this.getListeners().remove(link);
        }
    }

    public void eventReceived(EventObject event) {
        Trace.trace(TRACE_MASKT, "-> eventReceived(" + event + ")");
        ChainedObject obj = this.getChainedObject();
        if (obj == null) {
            this.delete();
            return;
        }
        if (obj.pass(event)) {
            this.fireEvent(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireEvent(EventObject event) {
        ArrayList arrayList = this._listeners;
        synchronized (arrayList) {
            Iterator i = this.getListeners().iterator();
            Linkable link = null;
            while (i.hasNext()) {
                link = (Linkable)i.next();
                if (link.isDeleted()) {
                    i.remove();
                    link.delete();
                    continue;
                }
                link.eventReceived(event);
            }
        }
    }

    public String toString() {
        return this.getClass().getName() + " for " + ((DescriptiveObject)this.getChainedObject()).getName();
    }
}

